/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWJoinType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSplitType;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import java.awt.Point;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class VWXML_10_parser {
    VWXML_10_parser() {
    }

    protected static VWWorkflowDefinition parseXMLWorkflow(Element wfele) throws VWException, SAXException {
        if (!wfele.getTagName().equals("WorkFlowDefinition")) {
            return null;
        }
        VWWorkflowDefinition wfdef = new VWWorkflowDefinition(true);
        wfdef.setVersionAgnostic(false);
        wfdef.setValidateUsingSchema(false);
        NodeList childNodes = wfele.getChildNodes();
        if (childNodes == null || childNodes.getLength() == 0) {
            return wfdef;
        }
        String deadlineStr = null;
        String reminderStr = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node aNode = childNodes.item(i);
            if (aNode.getNodeName().equals("Subject")) {
                wfdef.setSubject(VWXMLHandler.getXMLString(aNode));
                continue;
            }
            if (aNode.getNodeName().equals("Description")) {
                wfdef.setDescription(VWXMLHandler.getXMLString(aNode));
                continue;
            }
            if (aNode.getNodeName().equals("Name")) {
                wfdef.setName(VWXMLHandler.getXMLString(aNode));
                continue;
            }
            if (aNode.getNodeName().equals("MainAttachment")) {
                wfdef.setMainAttachmentNameNoValidate(VWXMLHandler.getXMLString(aNode));
                continue;
            }
            if (aNode.getNodeName().equals("Deadline")) {
                deadlineStr = VWXMLHandler.getXMLString(aNode);
                if (deadlineStr == null) continue;
                wfdef.setDeadline(Long.parseLong(deadlineStr));
                continue;
            }
            if (aNode.getNodeName().equals("Reminder")) {
                reminderStr = VWXMLHandler.getXMLString(aNode);
                if (reminderStr == null) continue;
                wfdef.setReminder(Long.parseLong(reminderStr));
                continue;
            }
            if (aNode.getNodeName().equals("FieldDefinition")) {
                VWXML_10_parser.parseXMLFieldDefinition(aNode, wfdef);
                continue;
            }
            if (!aNode.getNodeName().equals("MapDefinition")) continue;
            VWXML_10_parser.parseXMLMapDefinition(aNode, wfdef);
        }
        return wfdef;
    }

    protected static void parseXMLFieldDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        if (aNode.getNodeType() != 1) {
            return;
        }
        String nameStr = null;
        String descStr = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Name")) {
                nameStr = VWXMLHandler.getXMLString(childNode);
                continue;
            }
            if (!childNode.getNodeName().equals("Description")) continue;
            descStr = VWXMLHandler.getXMLString(childNode);
        }
        if (nameStr == null) {
            return;
        }
        Element ele = (Element)aNode;
        String valueStr = ele.getAttribute("ValueExpr");
        String typeStr = ele.getAttribute("Type");
        int typeInt = VWFieldType.stringToType(typeStr);
        String isArrayStr = ele.getAttribute("IsArray");
        boolean isArrayBool = VWXMLHandler.stringToBoolean(isArrayStr);
        String mergeTypeStr = ele.getAttribute("MergeType");
        int mergeInt = VWMergeType.stringToType(mergeTypeStr);
        VWFieldDefinition fldDef = nameStr.equals("F_Trackers") ? wfdef.createFieldNoValidateName(nameStr, valueStr, typeInt, isArrayBool) : wfdef.createFieldUsingString(nameStr, valueStr, typeInt, isArrayBool);
        if (VWMergeType.isValid(mergeInt)) {
            fldDef.setMergeType(mergeInt);
        }
        fldDef.setDescription(descStr);
    }

    protected static void parseXMLMapDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException, SAXException, NumberFormatException {
        NodeList childNodes = aNode.getChildNodes();
        String nameStr = null;
        String descStr = null;
        String stepIdStr = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Name")) {
                nameStr = VWXMLHandler.getXMLString(childNode);
                continue;
            }
            if (childNode.getNodeName().equals("Description")) {
                descStr = VWXMLHandler.getXMLString(childNode);
                continue;
            }
            if (!childNode.getNodeName().equals("MaxStepId")) continue;
            stepIdStr = VWXMLHandler.getXMLString(childNode);
        }
        if (nameStr == null) {
            return;
        }
        VWMapDefinition map = wfdef.createEmptyMap(nameStr);
        map.setDescription(descStr);
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("StepDefinition")) continue;
            VWXML_10_parser.parseXMLStepDefinition(childNode, map);
        }
        if (stepIdStr != null) {
            map.getStepIdGenerator().setNextId(Integer.parseInt(stepIdStr));
            map.getStepIdGenerator().getNextId();
        } else {
            map.updateNextStepId();
        }
    }

    protected static void parseXMLStepDefinition(Node aNode, VWMapDefinition map) throws VWException, SAXException {
        VWStepDefinition step = map.createEmptyStep();
        String xcoord = null;
        String ycoord = null;
        String deadlineStr = null;
        String reminderStr = null;
        String joinStepIdStr = null;
        VWArrayHandler partHandler = new VWArrayHandler(1, 1);
        VWArrayHandler responseHandler = new VWArrayHandler(1, 1);
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Name")) {
                step.setName(VWXMLHandler.getXMLString(childNode));
                continue;
            }
            if (childNode.getNodeName().equals("StepId")) {
                step.setStepId(Integer.parseInt(VWXMLHandler.getXMLString(childNode)));
                continue;
            }
            if (childNode.getNodeName().equals("Description")) {
                step.setDescription(VWXMLHandler.getXMLString(childNode));
                continue;
            }
            if (childNode.getNodeName().equals("XCoordinate")) {
                xcoord = VWXMLHandler.getXMLString(childNode);
                if (xcoord == null || ycoord == null) continue;
                step.setLocation(new Point(Integer.parseInt(xcoord), Integer.parseInt(ycoord)));
                continue;
            }
            if (childNode.getNodeName().equals("YCoordinate")) {
                ycoord = VWXMLHandler.getXMLString(childNode);
                if (xcoord == null || ycoord == null) continue;
                step.setLocation(new Point(Integer.parseInt(xcoord), Integer.parseInt(ycoord)));
                continue;
            }
            if (childNode.getNodeName().equals("Deadline")) {
                deadlineStr = VWXMLHandler.getXMLString(childNode);
                if (deadlineStr == null) continue;
                step.setDeadline(Long.parseLong(deadlineStr));
                continue;
            }
            if (childNode.getNodeName().equals("Reminder")) {
                reminderStr = VWXMLHandler.getXMLString(childNode);
                if (reminderStr == null) continue;
                step.setReminder(Long.parseLong(reminderStr));
                continue;
            }
            if (childNode.getNodeName().equals("JoinStepId")) {
                joinStepIdStr = VWXMLHandler.getXMLString(childNode);
                if (joinStepIdStr == null) continue;
                step.setJoinStepId(Integer.parseInt(joinStepIdStr));
                continue;
            }
            if (childNode.getNodeName().equals("RequestedInterface")) {
                step.setRequestedInterface(VWXMLHandler.getXMLString(childNode));
                continue;
            }
            if (childNode.getNodeName().equals("QueueName")) {
                step.setQueueName(VWXMLHandler.getXMLString(childNode));
                continue;
            }
            if (childNode.getNodeName().equals("Participant")) {
                VWParticipant newPart = new VWParticipant();
                newPart.setParticipantName(VWXMLHandler.getXMLString(childNode));
                step.setParticipants((VWParticipant[])partHandler.addElementToArray(step.getParticipants(), newPart));
                continue;
            }
            if (childNode.getNodeName().equals("Response")) {
                step.setResponses((String[])responseHandler.addElementToArray(step.getResponses(), VWXMLHandler.getXMLString(childNode)));
                continue;
            }
            if (childNode.getNodeName().equals("ParameterDefinition")) {
                VWXML_10_parser.parseXMLParameterDefinition(childNode, step);
                continue;
            }
            if (!childNode.getNodeName().equals("RouteDefinition")) continue;
            VWXML_10_parser.parseXMLRouteDefinition(childNode, map);
        }
        Element ele = (Element)aNode;
        String joinTypeStr = ele.getAttribute("JoinType");
        step.setJoinType(VWJoinType.stringToType(joinTypeStr));
        String splitTypeStr = ele.getAttribute("SplitType");
        step.setSplitType(VWSplitType.stringToType(splitTypeStr));
        String canReassign = ele.getAttribute("CanReassign");
        step.setCanReassign(VWXMLHandler.stringToBoolean(canReassign));
        String canViewStatus = ele.getAttribute("CanViewStatus");
        step.setCanViewStatus(VWXMLHandler.stringToBoolean(canViewStatus));
    }

    protected static void parseXMLRouteDefinition(Node aNode, VWMapDefinition map) throws VWException, SAXException, NumberFormatException {
        NodeList childNodes = aNode.getChildNodes();
        String name = null;
        String destStep = null;
        String sourceStep = null;
        String condition = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Name")) {
                name = VWXMLHandler.getXMLString(childNode);
                continue;
            }
            if (childNode.getNodeName().equals("SourceStepId")) {
                sourceStep = VWXMLHandler.getXMLString(childNode);
                continue;
            }
            if (childNode.getNodeName().equals("DestinationStepId")) {
                destStep = VWXMLHandler.getXMLString(childNode);
                continue;
            }
            if (!childNode.getNodeName().equals("Condition")) continue;
            condition = VWXMLHandler.getXMLString(childNode);
        }
        VWMapNode step = map.getStep(Integer.parseInt(sourceStep));
        VWRouteDefinition aRoute = step.createRoute(Integer.parseInt(destStep), condition, name);
        Element ele = (Element)aNode;
        String release = ele.getAttribute("Release");
        aRoute.setRelease(VWXMLHandler.stringToBoolean(release));
    }

    protected static void parseXMLParameterDefinition(Node aNode, VWStepDefinition step) throws VWException, SAXException, NumberFormatException {
        NodeList childNodes = aNode.getChildNodes();
        String name = null;
        String desc = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Name")) {
                name = VWXMLHandler.getXMLString(childNode);
                continue;
            }
            if (!childNode.getNodeName().equals("Description")) continue;
            desc = VWXMLHandler.getXMLString(childNode);
        }
        Element ele = (Element)aNode;
        String typeStr = ele.getAttribute("Type");
        int type = VWFieldType.stringToType(typeStr);
        String isArrayStr = ele.getAttribute("IsArray");
        boolean isArray = VWXMLHandler.stringToBoolean(isArrayStr);
        String modeStr = ele.getAttribute("Mode");
        int mode = VWModeType.stringToType(modeStr);
        String valueStr = ele.getAttribute("ValueExpr");
        VWParameterDefinition param = step.createParameter(name, mode, valueStr, type, isArray);
        param.setDescription(desc);
    }
}

